/* quilt.c
Quilt Block Layout Program
Copyright (c) 2010, Frank Cox <theatre@melvilletheatre.com
All rights reserved.
Redistribution and use in source and binary forms, with or without modification, are permitted
provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
THIS SOFTWARE IS PROVIDED BY FRANK COX ''AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL FRANK COX BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
OF SUCH DAMAGE.
*/



#include <stdio.h>
#include <stdlib.h>
#include <time.h>
int rnd(float max);
int main(void)
	{
	int counter,size,width,*blocks,*quilt,patterns,temp;
	printf("QUILT BLOCK RANDOM LAYOUT PROGRAM\n---------------------------------\nJune 20/2010  ");
	printf("Copyright (c) 2010, Frank Cox <theatre@melvilletheatre.com>\n");
	printf("Enter dimensions of the finished quilt\n\nHeight: ");
	scanf("%d",&size);
	printf("Width: ");
	scanf("%d",&width);
	size=size*width;
	quilt=malloc(size*sizeof(int));
	printf("\nEnter number of quilt block patterns: ");
	scanf("%d",&patterns);
	printf("\n");
	blocks=malloc(patterns*sizeof(int));
	temp=0;
	for (counter=0; counter < patterns; counter++)
		{
		printf("Enter number of pieces for pattern %d :",counter+1);
		scanf("%d",&blocks[counter]);
		temp=temp+blocks[counter];
		}
	if (temp != size)
		{
		free(blocks);
		free(quilt);
		printf("\nERROR: The quilt size is %d, but you specified a total number of %d pieces.",size,temp);
		exit(1);
		}
	temp=0;
	for (counter=0; counter < patterns; counter++)
		{
		int counter2;
		for (counter2=0; counter2 < blocks[counter]; counter2++)
			{
			quilt[temp]=counter;
			temp++;
			}
		}
	free(blocks);
	srand(time(NULL));
	printf("\nStarting Quilt Calculation\n--------------------------\n");
	printf("Depending on quilt size and your computer's speed, this may take a while . . .\n\n");
	do
		{
		for (counter=0; counter < size; counter++)
			{
			if (counter % width)
				if (quilt[counter]==quilt[counter-1])
					break;
			if (counter % width != width-1)
				if (quilt[counter]==quilt[counter+1])
					break;
			if (counter >= width && counter % width)
				if (quilt[counter]== quilt[counter-width-1])
					break;
			if (counter >= width)
				if (quilt[counter]== quilt[counter-width])
					break;
			if (counter >= width && counter % width != width-1)
				if (quilt[counter]== quilt[counter-width+1])
					break;
			if (counter % width && counter < size-width)
				if (quilt[counter]== quilt[counter+width-1])
					break;
			if (counter < size-width)
				if (quilt[counter]==quilt[counter+width])
					break;
			if (counter % width != width-1 && counter < size-width)
				if (quilt[counter]==quilt[counter+width+1])
					break;
			}
		if (counter < size)
			{
			temp=quilt[counter];
			patterns=rnd(size)-1;
			quilt[counter]=quilt[patterns];
			quilt[patterns]=temp;
			}
		} while (counter < size);
	printf("HERE IS YOUR QUILT PATTERN\n--------------------------\n");
	for (counter=0; counter < size; counter++)
		{
		printf("%02d ",quilt[counter]+1);
		if ((counter % width)==width-1)
			printf("\n");
		}
	free(quilt);
	return 0;
	}
int rnd(float max)
	{
	return 1+ (int) (max * (rand() / (RAND_MAX + 1.0)));
    }
